VERSION 5.00
Object = "{F8A2F63D-BF23-4B42-928C-CCB4545286D6}#9.2#0"; "CRDesignerCtrl.DLL"
Object = "{8767A745-088E-4CA6-8594-073D6D2DE57A}#9.2#0"; "crviewer9.dll"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Crystal Report Designer control Sample"
   ClientHeight    =   7890
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   10725
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   8461.126
   ScaleMode       =   0  'User
   ScaleWidth      =   10904.14
   StartUpPosition =   3  'Windows Default
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   5160
      Top             =   7320
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton cmdNew 
      Caption         =   "&New Report"
      Height          =   406
      Left            =   120
      TabIndex        =   6
      Top             =   7320
      Width           =   1623
   End
   Begin VB.CommandButton cmdOpen 
      Caption         =   "&Open Report"
      Height          =   406
      Left            =   1920
      TabIndex        =   5
      Top             =   7320
      Width           =   1623
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   406
      Left            =   8880
      TabIndex        =   4
      Top             =   7320
      Width           =   1623
   End
   Begin VB.CommandButton cmdAbout 
      Caption         =   "&About Sample"
      Height          =   406
      Left            =   7080
      TabIndex        =   3
      Top             =   7320
      Width           =   1623
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   7087
      Left            =   0
      TabIndex        =   0
      Top             =   120
      Width           =   10650
      _ExtentX        =   18785
      _ExtentY        =   12488
      _Version        =   393216
      Tabs            =   2
      TabHeight       =   520
      Enabled         =   0   'False
      TabCaption(0)   =   "Design"
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "CRDesigner1"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).ControlCount=   1
      TabCaption(1)   =   "Preview"
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "CRViewer1"
      Tab(1).ControlCount=   1
      Begin CRVIEWER9LibCtl.CRViewer9 CRViewer1 
         Height          =   6600
         Left            =   -74880
         TabIndex        =   2
         Top             =   360
         Width           =   10400
         lastProp        =   500
         _cx             =   5080
         _cy             =   5080
         DisplayGroupTree=   -1  'True
         DisplayToolbar  =   -1  'True
         EnableGroupTree =   -1  'True
         EnableNavigationControls=   -1  'True
         EnableStopButton=   -1  'True
         EnablePrintButton=   -1  'True
         EnableZoomControl=   -1  'True
         EnableCloseButton=   -1  'True
         EnableProgressControl=   -1  'True
         EnableSearchControl=   -1  'True
         EnableRefreshButton=   -1  'True
         EnableDrillDown =   -1  'True
         EnableAnimationControl=   -1  'True
         EnableSelectExpertButton=   0   'False
         EnableToolbar   =   -1  'True
         DisplayBorder   =   -1  'True
         DisplayTabs     =   -1  'True
         DisplayBackgroundEdge=   -1  'True
         SelectionFormula=   ""
         EnablePopupMenu =   -1  'True
         EnableExportButton=   0   'False
         EnableSearchExpertButton=   0   'False
         EnableHelpButton=   0   'False
         LaunchHTTPHyperlinksInNewBrowser=   -1  'True
      End
      Begin VB.PictureBox CRDesigner1 
         Height          =   6600
         Left            =   120
         ScaleHeight     =   6540
         ScaleWidth      =   10335
         TabIndex        =   1
         Top             =   360
         Width           =   10400
         Begin CRDESIGNERCTRLLibCtl.CRDesignerCtrl CRDesignerCtrl1 
            Height          =   6540
            Left            =   0
            OleObjectBlob   =   "frmMain.frx":0442
            TabIndex        =   7
            Top             =   0
            Width           =   10325
         End
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' *************************************************************
' Purpose:  Demonstrate how to display  a report in the
'           Embeddable Crystal Reports Designer Control
'           (Embeddable Designer) and preview the report.
'           (New to Crystal Reports 8.5)
'
'           The Embeddable Designer allows the developer to display
'           a fully functional Crystal Reports designer at runtime.
'
'           In this sample the Embeddable Designer can be set to
'           either a new or existing report. Once the report is
'           designed or edited click the 'Preview' tab to display
'           the report.
'

Option Explicit

Private Const OpenDialogFilter As String = "Crystal Reports |*.rpt"
Private errString, errTitle As String

Dim m_Application As New CRAXDDRT.Application
Dim m_Report As CRAXDDRT.Report

' *************************************************************
'DisplayReport is a procedure that
' - Enables the Tab control the first time a report is created
'   or opened.
' - Sets the report object to the Embeddable Designer(CRDesigner1).
' - Disables the Help menu in the Embeddable Designer.
' - Sets the report object to the Crystal Report Viewer Control
'   (CRViewer1).
' - Sets the Crystal Reports Viewer to view the report.
'
Public Sub DisplayReport()
On Error GoTo errhandler
' Enable the tab control if disabled.
If SSTab1.Enabled = False Then SSTab1.Enabled = True

' Set the Report Object
CRDesignerCtrl1.ReportObject = m_Report
 
' Note----------------
' Set all other properties for CRDesignerCtrl1 after setting the
' ReportObject property
' --------------------
 
' Disable the Help menu
CRDesignerCtrl1.EnableHelp = False

' Set the report source
CRViewer1.ReportSource = m_Report

' Set the zoom level to fit the page width to the
' viewer window
CRViewer1.Zoom 1

' Set the viewer to view the report
CRViewer1.ViewReport

Exit Sub
errhandler:
    errString = "Error # " & CStr(Err.Number) & " " & Err.Description
    errTitle = Err.Source
    MsgBox errString, vbCritical, errTitle
End Sub

' *************************************************************
Private Sub Form_Load()
'Set the tab control to display the Designer tab
'when the form is loaded
SSTab1.Tab = 0
End Sub

' *************************************************************
Private Sub SSTab1_Click(PreviousTab As Integer)
' Refresh the report when clicking on the Preview tab
' Without refreshing the data from the server
If PreviousTab = 0 Then CRViewer1.RefreshEx False

End Sub

' *************************************************************
' Create a new report and display it in the Embeddable Designer
'
Private Sub cmdNew_Click()
On Error GoTo errhandler
' Set the report object to nothing
Set m_Report = Nothing

' Create a new report
Set m_Report = m_Application.NewReport

' Call the procedure to set the report to the Embeddable Designer
' and the Crystal Report Viewer and then display the report in the
' Embeddable Designer.
Call DisplayReport

Exit Sub
errhandler:
    errString = "Error # " & CStr(Err.Number) & " " & Err.Description
    errTitle = Err.Source
    MsgBox errString, vbCritical, errTitle
End Sub

' *************************************************************
' Use the Microsoft Common Dialog control to open a report.
'
Private Sub cmdOpen_Click()
' Set Cancel to True
CommonDialog1.CancelError = True

On Error GoTo errhandler

' Filter the Open dialog box to display
' Crystal Reports files only.
CommonDialog1.Filter = OpenDialogFilter

' Display the open dialog box
CommonDialog1.ShowOpen

' Set the report object to nothing
Set m_Report = Nothing

' Open the selected report
Set m_Report = m_Application.OpenReport(CommonDialog1.FileName, 1)

' Call the procedure to set the report to the Embeddable Designer
' and the Crystal Report Viewer
Call DisplayReport

Exit Sub

errhandler:
Select Case Err.Number
Case 32755
    'User cancelled dialog
Case Else
    errString = "Error # " & CStr(Err.Number) & " " & Err.Description
    errTitle = Err.Source
    MsgBox errString, vbCritical, errTitle
End Select
End Sub

' *************************************************************
Private Sub cmdAbout_Click()
frmAbout.Show vbModal
End Sub

' *************************************************************
Private Sub cmdExit_Click()
Unload Me
End Sub



